<?php
// Wyznaczenie opcji dla listy rozwijanej
$flavors = array('Waniliowy','Czekoladowy','Orzechowy');

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // Wywietlenie formularza, jeli metod dania jest GET
    display_form(array());
} else {
    // Jeli metod adania jest POST, trzeba zweryfikowa dostarczone dane
    $errors = validate_form();
    if (count($errors)) {
        // Jeli s bdy, formularz musi by wywietlony ponownie wraz z komunikatami
        display_form($errors);
    } else {
        // Dane s poprawne, wic uytkownikowi nale si gratulacje
        print 'Formularz zosta przesany!';
    }
}   

function display_form($errors) {
    global $flavors;
    
    // Ustwienie wartoci domylnych
    $defaults['name'] = isset($_POST['name']) ? htmlentities($_POST['name']) : '';
    $defaults['age'] = isset($_POST['age']) ? "checked='checked'" : '';
    foreach ($flavors as $flavor) {
        if (isset($_POST['flavor']) && ($_POST['flavor'] == $flavor)) {
            $defaults['flavor'][$flavor] = "selected='selected'";
        } else {
            $defaults['flavor'][$flavor] = '';
        }
    }
    ?>

<form action='<?php echo $_SERVER['SCRIPT_NAME'] ?>' method='post'>
<dl>
<dt>Nazwisko:</dt>
<?php print_error('name', $errors) ?>
<dd><input type='text' name='name' value='<?php echo $defaults['name'] ?>'/></dd>
<dt>Czy masz wicej ni 18 lat? </dt>
<?php print_error('age', $errors) ?>
<dd><input type='checkbox' name='age' value='1' <?php echo $defaults['age'] ?>/> Yes</dd>
<dt>Twj ulubiony smak lodw:</dt>
<?php print_error('flavor', $errors) ?>
<dd><select name='flavor'>
<?php foreach ($flavors as $flavor) {
    echo "<option {$defaults['flavor'][$flavor]}>$flavor</option>";
} ?>
</select></dd>
</dl>
<input type='submit' value='Przelij informacje'/>
</form>
<?php }

// Funkcja pomocnicza, generujca kod HTML komunikatu o bdzie
function print_error($key, $errors) {
    if (isset($errors[$key])) {
        print "<dd class='error'>{$errors[$key]}</dd>";
    }
}

function validate_form() {
    global $flavors;
    
    // Rozpoczcie przetwarzania bez jakichkolwiek bdw
    $errors = array();
    
    // Nazwisko jest obowizkowe i musi si skada co najmniej z trzech liter
    if (! (isset($_POST['name']) && (strlen($_POST['name']) > 3))) {
        $errors['name'] = 'Wprowad nazwisko skadajce si z co najmniej trzech liter';
    }
    if (isset($_POST['age']) && ($_POST['age'] != '1')) {
        $errors['age'] = 'Bdna warto pola wieku.';
    }
    // Dane o smaku s opcjonalne, ale jeli zostay przesane, musz nalee do 
    // zdefiniowanych w tablicy $flavors
    if (isset($_POST['flavor']) && (! in_array($_POST['flavor'], $flavors))) {
        $errors['flavor'] = 'Wybierz poprawny smak.';
    }
    
    return $errors;
}
?>
